require( "quest/activity_mode/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
		
		if IsCheatMode() then
			
		end;
	end;
};

activity_image_spec = 
{
	name = "ACTIVITY_IMAGE_SPEC";
	gfx = { image = "buttons/activity_level_beading" };
	
	command = function(actor)
		actor:JumpToPoint{ x = 88, y = -10 };
		actor:SetDepthValue(10);
		local activity_name = game:GetString("activity_mode_name");
		
		if activity_name ~= nil then
			actor:LoadImage("buttons/activity_level_" .. activity_name);
		end
	end;
}

generic_activity_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	color_over = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	w = 300,
	h = 30,
	bubble = false,
	lineheight = 30,
	outline_size = 0,
	font = "fonts/franklingothic_demicond.mvec"; 
	anchor = ANCHOR.CENTER;
	halign = HALIGN.LEFT;
};

activity_text_spec = 
{
	name = "ACTIVITY_TEXT_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 330, y = 110 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 220,
			h = 285,
			lineheight = 25,
			halign = HALIGN.CENTER,
		};
		
		local activity_name = game:GetString("activity_mode_name");
		
		if activity_name ~= nil then
			actor:Say("activity_" .. activity_name);
		end
	end;
}

activity_level_spec = 
{
	name = "ACTIVITY_LEVEL_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 372, y = 150 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 130,
			h = 30,
			lineheight = 17,
			halign = HALIGN.CENTER,
		};
		
		local activity_level = game:Get("activity_dialog_level");
		
		if activity_level ~= nil then
			actor:SayRaw(scene:grabstring("level") .. " " .. tostring(activity_level));
		end
	end;
}

activity_praise_spec = 
{
	name = "ACTIVITY_PRAISE_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 230, y = 192 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 320,
			h = 30,
			lineheight = 20,
			halign = HALIGN.CENTER,
		};
		
		local activity_expert = game:Get("activity_dialog_expert");
		
		if activity_expert == 1 then
			actor:Say("activity_praise_high");
		elseif activity_expert == 0 then
			actor:Say("activity_praise_mid");
		else
			actor:Say("activity_praise_low");
		end
	end;
}

activity_time_text_a_spec = 
{
	name = "ACTIVITY_TIME_TEXT_A_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 230, y = 224 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 320,
			h = 30,
			lineheight = 20,
			halign = HALIGN.CENTER,
		};
		
		actor:Say("activity_level_time_a");
	end;
}

activity_time_text_b_spec = 
{
	name = "ACTIVITY_TIME_TEXT_B_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 230, y = 264 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 320,
			h = 30,
			lineheight = 20,
			color = { a = 1, r = 0, g = 0, b = 1 };
			halign = HALIGN.CENTER,
		};
		
		local activity_time = game:Get("activity_dialog_time");
		
		if activity_time ~= nil then
			local seconds = activity_time / 1000;
			local minutes = seconds / 60;
			seconds = fmod(seconds, 60);
			
			if minutes > 99 then
				minutes = 99;
				seconds = 99;
			end
			
			local secondstring = string.format("%d", seconds);
			local minutestring = string.format("%d", minutes);
			
			if minutestring == "1" then
				minutestring = scene:grabformattedstring("activity_level_time_b", { minutestring } );
			else
				minutestring = scene:grabformattedstring("activity_level_time_c", { minutestring } );
			end
			
			if secondstring == "1" then
				secondstring = scene:grabformattedstring("activity_level_time_d", { secondstring } );
			else
				secondstring = scene:grabformattedstring("activity_level_time_e", { secondstring } );
			end
			
			local timestring = string.format("%s %s", minutestring, secondstring);
			
			actor:SayRaw(timestring);
		else
			local timestring = string.format("%s %s", scene:grabformattedstring("activity_level_time_c", 0), scene:grabformattedstring("activity_level_time_e", 0));
		end
	end;
}

activity_score_text_spec = 
{
	name = "ACTIVITY_SCORE_TEXT_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 285, y = 307 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 75,
			h = 30,
			lineheight = 20,
			halign = HALIGN.RIGHT,
		};
		
		actor:Say("activityscore");
	end;
}

activity_score_spec = 
{
	name = "ACTIVITY_SCORE_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 360, y = 307 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 65,
			h = 30,
			lineheight = 20,
			color = { a = 1, r = 0, g = 0, b = 1 };
			
			halign = HALIGN.CENTER,
		};
		
		local score = game:Get("activity_dialog_score");
		
		if score ~= nil then
			actor:SayRaw(score);
		end
	end;
}

activity_expert_spec = 
{
	name = "ACTIVITY_EXPERT_SPEC";
	gfx = { image = "buttons/activity_expertstar" };
	
	command = function(actor)
		actor:JumpToPoint{ x = 427, y = 295 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 75,
			h = 17,
			x = 28,
			y = 20,
			lineheight = 14,
		};
		
		local activity_expert = game:Get("activity_dialog_expert");
		
		if activity_expert == 1 then
			actor:Say("activity_bar_high");
		else
			actor:SetAlpha(0);
		end
	end;
}

activity_total_score_text_spec = 
{
	name = "ACTIVITY_TOTAL_SCORE_TEXT_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 260, y = 353 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 150,
			h = 30,
			lineheight = 20,
			halign = HALIGN.RIGHT,
		};
		
		actor:Say("activitytotalscore");
	end;
}

activity_total_score_spec = 
{
	name = "ACTIVITY_TOTAL_SCORE_SPEC";
	
	command = function(actor)
		actor:JumpToPoint{ x = 430, y = 353 };
		actor:ModifySaySpec(generic_activity_text_spec);
		actor:ModifySaySpec
		{
			w = 80,
			h = 30,
			lineheight = 20,
			color = { a = 1, r = 0, g = 0, b = 1 };
		};
		
		local score = game:Get("activity_dialog_total_score");
		
		if score ~= nil then
			actor:SayRaw(score);
		end
	end;
}

next_level_button_spec = 
{
	name = "NEXT_LEVEL_BUTTON";
	text = "nextlevel";
	halo = "quest/objects/button_thin";
	position = { x = 415, y = 400 };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 14,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		game:Set("activity_mode_next_level", 1);
		scene:ReturnFromScene();
	end;
}

replay_level_button_spec = 
{
	name = "REPLAY_LEVEL_BUTTON";
	text = "replay";
	halo = "quest/objects/button_thin";
	position = { x = 285, y = 400 };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 14,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		game:Set("activity_mode_next_level", 0);
		scene:ReturnFromScene();
	end;
}

return_button_spec = 
{
	name = "RETURN_BUTTON";
	text = "back";
	halo = "quest/objects/button_thin";
	position = { x = 350, y = 440 };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 14,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		game:Set("activity_mode", 0);
		game:SaveGame();
		sfx:PlayMusic("audio/music/mainmenumusic", true);
		game:Set("activity_mode_next_level", -1);
		scene:QuitToLastMenu();
	end;
}

activity_dialog_background_spec = 
{
	name = "ACTIVITY_DIALOG_BACKGROUND";
	gfx = { image = "backgrounds/largedialog" };
	
	command = function(actor)
		actor:SetDepthValue(DEPTH.DEPTH_BACKMOST);
		actor:JumpToPoint { x = 160, y = 40 };
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		--sfx:SetMusic("audio/music/office.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true, true);
		lower_hud();
		
		if IsCheatMode() then
			-- testing data
		end
		
		scene:Spawn(activity_image_spec);
		scene:Spawn(activity_text_spec);
		scene:Spawn(activity_level_spec);
		scene:Spawn(activity_praise_spec);
		scene:Spawn(activity_time_text_a_spec);
		scene:Spawn(activity_time_text_b_spec);
		scene:Spawn(activity_score_text_spec);
		scene:Spawn(activity_score_spec);
		scene:Spawn(activity_expert_spec);
		scene:Spawn(activity_total_score_text_spec);
		scene:Spawn(activity_total_score_spec);
		
		spawn_button(replay_level_button_spec);
		spawn_button(return_button_spec);
		
		local activity_level = game:Get("activity_dialog_level");
		local activity_mode_name = game:GetString("activity_mode_name");
		
		if activity_level < ACTIVITY_LEVEL_MAX then
			spawn_button(next_level_button_spec);
		else
			local award = "";
			if activity_mode_name == "beading" then
				if game:HasAward("avenue-flo_beadingmaster") == false then
					award = "avenue-flo_beadingmaster";
				end
			elseif activity_mode_name == "clothing" then
				if game:HasAward("avenue-flo_clothingdisplay") == false then
					award = "avenue-flo_clothingdisplay";
				end
			elseif activity_mode_name == "package" then
				if game:HasAward("avenue-flo_packaging") == false then
					award = "avenue-flo_packaging";
				end
			elseif activity_mode_name == "chicken_field" then
				if game:HasAward("avenue-flo_chickenchaser") == false then
					award = "avenue-flo_chickenchaser";
				end
			elseif activity_mode_name == "chicken_chorus" then
				if game:HasAward("avenue-flo_chickenconductor") == false then
					award = "avenue-flo_chickenconductor";
				end
			elseif activity_mode_name == "dough_ball" then
				if game:HasAward("avenue-flo_doughballwrangler") == false then
					award = "avenue-flo_doughballwrangler";
				end
			end
			
			if award ~= "" then
				game:EarnAward(award);
				scene:DoPopup("", "pop_award_text_title", "pop_award_text_body");
				wait_subscene();
			end
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "activity_dialog_overlay", 1 },
		
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		scene_setup,
		activity_dialog_background_spec,
	};
};
